/*

   Venus.H

   (c) Diamond Systems Corporation 2017

http://www.diamondsystems.com

(c) Copyright 2016 Diamond Systems Corporation. Use of this source code
is subject to the terms of Diamond Systems' Software License Agreement.
Diamond Systems provides no warranty of proper performance if this
source code is modified.
 */


#ifndef _DSC_JASPER_H
#define _DSC_JASPER_H

#include <stdint.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <windows.h>
#include <winioctl.h>
#include <conio.h>

void dscSleep(UINT milliseconds);



///////////////////////
// Bit Value
///////////////////////

#define Jasper_GPIO_BIT_HIGH 	  1
#define Jasper_GPIO_BIT_LOW		  0



/////////////////////////
//Varible
////////////////////////
typedef unsigned char BYTE;

typedef unsigned int UINT;

typedef struct
{
	BYTE ErrCode;
	char errstring[100];
	char* errfunct;
} ERRPARAMS;

/////////////////////////
// Function Prototypes //
/////////////////////////

BYTE SetLastErrorGPIO(BYTE error_code, const char* error_str);
BYTE GetLastErrorGPIO(ERRPARAMS* errparams);
char* GetErrorString(ERRPARAMS* errparams);


BYTE Jasper1185GREGPIOInitBoard();
BYTE Jasper1185GREGPIOFreeBoard();
BYTE Jasper1185GREGPIOConfig(UINT dir);
BYTE Jasper1185GREGPIOOutputBit(UINT bit, UINT value);
BYTE Jasper1185GREGPIOInputBit(UINT bit, UINT* value);
BYTE Jasper1185GREGPIOOutputByte(UINT value);
BYTE Jasper1185GREGPIOInputByte(UINT* value);



///////////////////////////
// Error Code
///////////////////////////

#define DE_NONE					0
#define HW_FAILURE				1
#define SW_FAILURE				2
#define DE_INVALID_PARM			3

//////////////////////////
// Error String
/////////////////////////

#define STR_DE_NONE					"NO ERROR Reported"
#define STR_HW_FAILURE					"HARDWARE FAILURE"
#define STR_SW_FAILURE					"SOFTWARE FAILURE"
#define STR_DE_INVALID_PARM				"INVALID PARAMETER"

#endif //#ifndef _DSC_VENUS_H
